#!/bin/bash

WWW_BASE='/Library/WebServer/Documents'
TARGET="$WWW_BASE"

expand_dir () {
  pushd "$1" >/dev/null
  DIR="`pwd`"
  popd >/dev/null
}

expand_dir `dirname $0`

clear

if [ -e "$WWW_BASE"/orbit ]; then
    echo 'Nothing to be done - linked already.'
else
    echo "Going to add link in $TARGET - 'sudo' may ask you for your password."

    ln -s "$DIR"/server/www/orbit $TARGET

    if [ $? -eq 0 ]; then
        echo 'Done.'
    else
        echo 'Failed (not an admin user or failed to authenticate).'
    fi
fi